/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.animal;

import java.util.List;
import java.util.UUID;
import lotr.common.LOTRMod;
import lotr.common.entity.LOTREntities;
import lotr.common.entity.LOTRRandomSkinEntity;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide2;
import lotr.common.entity.ai.LOTREntityAIAvoidWithChance;
import lotr.common.entity.animal.LOTRAmbientCreature;
import lotr.common.entity.animal.LOTREntityBear;
import lotr.common.entity.animal.LOTREntityPolarBear;
import lotr.common.entity.animal.LOTREntityRabbit;
import lotr.common.entity.npc.LOTREntityMan;
import lotr.common.entity.npc.LOTREntityWarg;
import lotr.common.world.biome.LOTRBiomeGenForodwaith;
import lotr.common.world.biome.LOTRBiomeGenGondor;
import lotr.common.world.biome.LOTRBiomeGenIthilien;
import lotr.common.world.biome.LOTRBiomeGenLastDesert;
import lotr.common.world.biome.LOTRBiomeGenNearHarad;
import lotr.common.world.biome.LOTRBiomeGenPukel;
import lotr.common.world.biome.LOTRBiomeGenRedSemiDesert;
import lotr.common.world.biome.LOTRBiomeGenRhunSemiDesert;
import lotr.common.world.biome.LOTRBiomeGenRohan;
import lotr.common.world.biome.LOTRBiomeGenTaiga;
import lotr.common.world.biome.LOTRBiomeGenTaiga2;
import lotr.common.world.biome.LOTRBiomeGenTaigaRhun;
import lotr.common.world.biome.LOTRBiomeGenTundra;
import lotr.common.world.biome.LOTRBiomeGenTundra2;
import lotr.common.world.biome.LOTRBiomeGenTundra3;
import lotr.common.world.biome.LOTRBiomeGenTundra4;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTREntityFox
extends EntityAnimal
implements LOTRAmbientCreature,
LOTRRandomSkinEntity,
LOTRBiomeGenNearHarad.ImmuneToFrost {
    public IEntitySelector foxAttackRange = new IEntitySelector(){

        public boolean func_82704_a(Entity entity) {
            return entity instanceof EntityLivingBase && entity.func_70089_S() && LOTREntityFox.this.func_70068_e(entity) < 16.0;
        }
    };
    public EntityAIBase attackAI = new LOTREntityAIAttackOnCollide2((EntityCreature)this, 1.4, true);
    public EntityAIBase panicAI = new EntityAIPanic((EntityCreature)this, 1.5);
    public static boolean wreckAnimals;

    public LOTREntityFox(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.0f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, this.panicAI);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new LOTREntityAIAvoidWithChance((EntityCreature)this, EntityPlayer.class, 12.0f, 1.5, 2.0, 0.1f));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 2.0));
        this.field_70714_bg.func_75776_a(1, this.attackAI);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityWolf.class, 12.0f, 1.5, 2.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntityBear.class, 12.0f, 1.5, 2.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntityWarg.class, 12.0f, 1.5, 2.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntityPolarBear.class, 12.0f, 1.5, 2.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.4));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.4, Items.field_151076_bf, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 15.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, LOTREntityRabbit.class, 0, true, false, this.foxAttackRange));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityChicken.class, 0, true, false, this.foxAttackRange));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.5);
    }

    public boolean func_70652_k(Entity entity) {
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
        if (flag) {
            float kb = 0.75f;
            entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * kb * 0.5f), 0.0, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * kb * 0.5f));
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource damagesource, float f) {
        Entity attacker;
        boolean flag = super.func_70097_a(damagesource, f);
        if (flag && this.func_70631_g_() && (attacker = damagesource.func_76346_g()) instanceof EntityLivingBase) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(12.0, 12.0, 12.0));
            for (Entity entity : list) {
                LOTREntityFox fox;
                if (entity.getClass() != this.getClass() || (fox = (LOTREntityFox)entity).func_70631_g_()) continue;
                fox.func_70624_b((EntityLivingBase)attacker);
            }
        }
        return flag;
    }

    public EntityAgeable func_90011_a(EntityAgeable entity) {
        LOTREntityFox mate = (LOTREntityFox)entity;
        LOTREntityFox child = new LOTREntityFox(this.field_70170_p);
        if (this.field_70146_Z.nextBoolean()) {
            child.setFoxType(this.getFoxType());
        } else {
            child.setFoxType(mate.getFoxType());
        }
        return child;
    }

    protected void func_70628_a(boolean flag, int i) {
        int meat = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + i);
        for (int l = 0; l < meat; ++l) {
            this.func_145779_a(Items.field_151116_aA, 1);
        }
    }

    public boolean func_70877_b(ItemStack itemstack) {
        return itemstack.func_77973_b() == Items.field_151076_bf;
    }

    public boolean func_70692_ba() {
        return true;
    }

    public float func_70783_a(int i, int j, int k) {
        Block block = this.field_70170_p.func_147439_a(i, j - 1, k);
        if (block == Blocks.field_150349_c) {
            return 10.0f;
        }
        return this.field_70170_p.func_72801_o(i, j, k) - 0.5f;
    }

    protected String func_70673_aS() {
        return "lotr:fox.death";
    }

    protected String func_70621_aR() {
        return "lotr:fox.hurt";
    }

    protected String func_70639_aQ() {
        return "lotr:fox.say";
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(LOTRMod.spawnEgg, 1, LOTREntities.getEntityID((Entity)this));
    }

    public float func_70647_i() {
        return super.func_70647_i() * 1.3f;
    }

    public boolean func_70650_aV() {
        return true;
    }

    @Override
    public void setUniqueID(UUID uuid) {
        this.field_96093_i = uuid;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)1);
    }

    public String getFoxTextureDir() {
        return this.getFoxType().textureDir;
    }

    public FoxType getFoxType() {
        byte i = this.field_70180_af.func_75683_a(16);
        if (i < 0 || i >= FoxType.values().length) {
            i = 0;
        }
        return FoxType.values()[i];
    }

    public void setFoxType(FoxType type) {
        this.setFoxType(type.ordinal());
    }

    public void setFoxType(int i) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)i));
    }

    public boolean isFoxStill() {
        return this.field_70180_af.func_75683_a(17) == 1;
    }

    public void setFoxStill(boolean flag) {
        this.field_70180_af.func_75692_b(17, (Object)((byte)(flag ? 1 : 0)));
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        int k;
        data = super.func_110161_a(data);
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k = MathHelper.func_76128_c((double)this.field_70161_v));
        if (biome instanceof LOTRBiomeGenTundra || biome instanceof LOTRBiomeGenTaiga || biome instanceof LOTRBiomeGenTaiga2 || biome instanceof LOTRBiomeGenTaigaRhun || biome instanceof LOTRBiomeGenTundra2 || biome instanceof LOTRBiomeGenTundra4 || biome instanceof LOTRBiomeGenTundra3 || biome instanceof LOTRBiomeGenForodwaith) {
            this.setFoxType(FoxType.SNOW);
        } else if (biome instanceof LOTRBiomeGenLastDesert || biome instanceof LOTRBiomeGenRhunSemiDesert || biome instanceof LOTRBiomeGenRedSemiDesert || biome instanceof LOTRBiomeGenNearHarad) {
            this.setFoxType(FoxType.DESERT);
        } else if (biome instanceof LOTRBiomeGenGondor || biome instanceof LOTRBiomeGenIthilien || biome instanceof LOTRBiomeGenPukel || biome instanceof LOTRBiomeGenRohan) {
            this.setFoxType(FoxType.MIDDLE);
        } else {
            this.setFoxType(FoxType.COMMON);
        }
        return data;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.getFoxType() == FoxType.SNOW && this.func_70638_az() == null) {
            List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(16.0, 8.0, 16.0));
            for (EntityPlayer player : players) {
                if (!(player instanceof EntityPlayer) || player.field_71075_bZ.field_75098_d) continue;
                this.func_70624_b((EntityLivingBase)player);
                return;
            }
            List entities = this.field_70170_p.func_72872_a(LOTREntityMan.class, this.field_70121_D.func_72314_b(16.0, 8.0, 16.0));
            for (Entity entity : entities) {
                if (!(entity instanceof LOTREntityMan)) continue;
                this.func_70624_b((EntityLivingBase)entity);
                return;
            }
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setFoxType(nbt.func_74762_e("FoxType"));
        this.setFoxStill(nbt.func_74767_n("FoxStill"));
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("FoxType", this.getFoxType().ordinal());
        nbt.func_74757_a("FoxStill", this.isFoxStill());
    }

    public static enum FoxType {
        COMMON("common", true),
        DESERT("desert", true),
        MIDDLE("middle", true),
        SNOW("snow", true);

        public boolean canSteal;
        public String textureDir;

        private FoxType(String s, boolean flag) {
            this.textureDir = s;
            this.canSteal = flag;
        }
    }
}

